<?php

// Include the database connection file

include("db.php");



// Start the session

session_start();



// Set content type to JSON

header('Content-Type: application/json');



// Check if the method is POST

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    // Initialize variables

    $store_image = null;

    

    // Get JSON input

    $input = json_decode(file_get_contents('php://input'), true);

    

    // Check if user is logged in

    if (!isset($_SESSION['user_id'])) {

        echo json_encode(['status' => 'error', 'message' => 'User not logged in']);

        exit();

    }

    $user_id = $_SESSION['user_id'];



    // Validate required fields

    $requiredFields = ['name', 'email', 'phone', 'street1', 'city', 'pincode'];

    foreach ($requiredFields as $field) {

        if (empty($input[$field])) {

            echo json_encode(['status' => 'error', 'message' => "$field is required"]);

            exit();

        }

    }



    // Handle base64 image if present

    if (!empty($input['store_image'])) {

        $uploadDir = 'images/';

        $fileName = uniqid() . '.jpg'; // or .png based on your needs

        $targetFilePath = $uploadDir . $fileName;

        

        // Create directory if it doesn't exist

        if (!is_dir($uploadDir)) {

            mkdir($uploadDir, 0755, true);

        }

        

        // Decode base64 image

        $imageData = base64_decode($input['store_image']);

        if ($imageData === false) {

            echo json_encode(['status' => 'error', 'message' => 'Invalid image data']);

            exit();

        }

        

        // Save the file

        if (file_put_contents($targetFilePath, $imageData)) {

            $store_image = 'https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/images/' . $fileName;

        } else {

            echo json_encode(['status' => 'error', 'message' => 'Failed to save image']);

            exit();

        }

    }



    // Sanitize input

    $name = mysqli_real_escape_string($conn, $input['name']);

    $email = mysqli_real_escape_string($conn, $input['email']);

    $phone = mysqli_real_escape_string($conn, $input['phone']);

    $address = mysqli_real_escape_string($conn, $input['street1']);

    $street2 = isset($input['street2']) ? mysqli_real_escape_string($conn, $input['street2']) : '';

    $city = mysqli_real_escape_string($conn, $input['city']);

    $pincode = mysqli_real_escape_string($conn, $input['pincode']);

    $storename = isset($input['storename']) ? mysqli_real_escape_string($conn, $input['storename']) : '';

    $ifsc = isset($input['ifsc']) ? mysqli_real_escape_string($conn, $input['ifsc']) : '';

    $acountno = isset($input['acountno']) ? mysqli_real_escape_string($conn, $input['acountno']) : '';

    $bankname = isset($input['bankname']) ? mysqli_real_escape_string($conn, $input['bankname']) : '';

    $actype = isset($input['actype']) ? mysqli_real_escape_string($conn, $input['actype']) : '';

    $upiid = isset($input['upiid']) ? mysqli_real_escape_string($conn, $input['upiid']) : '';

    $fburl = isset($input['fburl']) ? mysqli_real_escape_string($conn, $input['fburl']) : '';

    $twurl = isset($input['twurl']) ? mysqli_real_escape_string($conn, $input['twurl']) : '';

    $liurl = isset($input['liurl']) ? mysqli_real_escape_string($conn, $input['liurl']) : '';

    $insurl = isset($input['insurl']) ? mysqli_real_escape_string($conn, $input['insurl']) : '';

    $youurl = isset($input['youurl']) ? mysqli_real_escape_string($conn, $input['youurl']) : '';



    // Begin transaction

    $conn->begin_transaction();



    try {

        // Build the SQL query for user_profile

        $updateProfileSql = "UPDATE user_profile 

                            SET 

                                acount_name = '$name', 

                                Email = '$email', 

                                Phone = '$phone', 

                                Address = '$address', 

                                street2 = '$street2', 

                                City = '$city', 

                                Pincode = '$pincode',

                                store_name = '$storename', 

                                ifsc = '$ifsc', 

                                acount_no = '$acountno',  

                                bank_name = '$bankname', 

                                acount_type = '$actype', 

                                upiid = '$upiid',

                                fburl = '$fburl', 

                                twurl = '$twurl', 

                                liurl = '$liurl', 

                                insurl = '$insurl',

                                youurl = '$youurl'";

        

        // Add store_image to query if it was uploaded

        if ($store_image !== null) {

            $updateProfileSql .= ", store_image = '$store_image'";

        }

        

        $updateProfileSql .= " WHERE User_id = '$user_id';";



        if ($conn->query($updateProfileSql) === FALSE) {

            throw new Exception("Error updating user_profile");

        }



        // Update user_login table

        $updateLoginSql = "UPDATE user_login 

                           SET Name = '$name', Email = '$email', Phone = '$phone'

                           WHERE Delete_status = '0' AND Id = '$user_id';";



        if ($conn->query($updateLoginSql) === FALSE) {

            throw new Exception("Error updating user_login");

        }



        // Commit the transaction

        $conn->commit();



        // Send success response

        echo json_encode(['status' => 'success', 'message' => 'User information updated successfully']);

    } catch (Exception $e) {

        // Rollback the transaction if any query fails

        $conn->rollback();



        // Send error response

        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);

    }

} else {

    // Method not allowed

    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);

}



// Close the database connection

$conn->close();

?>